package game;

import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

import javax.swing.JOptionPane;


public class RogueBlockSpawnPoint {
	
	private boolean isMoving;
	private char initDir;
	private int initXPos;
	private int initYPos;
	private boolean isPassThru;
	private Color transparentColor;
	private int width;
	private int height;
	private CustomImageDataII image;
	private int minX = -1;
	private int minY = -1;
	private int maxX = -1;
	private int maxY = -1;
	private boolean isVertical = false;
	private boolean isHorizontal = false;
	private boolean isConveyor = false;
	private int moveSpeed = -1;
	private String name = null;
	private String names[] = null;
	private String transparentColors[] = null;
	private CustomImageDataII animation[] = null;
	
	private RogueBlockSpawnPoint() {
		
	}

	
	
	
//	f(isHorizontal) {
//		MovingBlockSprite returnValue = new MovingBlockSprite(cid, width, height, xPos, yPos, passThru,
//				MovingBlockSprite.MOVE_MODE_EAST_WEST, minX, maxX, initDir, moveSpeed, name);
//		
//		
//		return returnValue;
//	} else if(isVertical) {
//		MovingBlockSprite returnValue = new MovingBlockSprite(cid, width, height, xPos, yPos, passThru,
//				MovingBlockSprite.MOVE_MODE_NORTH_SOUTH, minY, maxY, initDir, moveSpeed, name);
//		
//		
//		return returnValue;
//	}
	
	public SolidBlockSprite createBlock() {
		
		
		if(isHorizontal) {
			//create a horizontal block
			
			return new MovingBlockSprite(image, width, height, initXPos, initYPos, isPassThru,
					MovingBlockSprite.MOVE_MODE_EAST_WEST, minX, maxX, initDir, moveSpeed, name);
			
		} else if(isVertical) {
			//create a vertical block
			
			return new MovingBlockSprite(image, width, height, initXPos, initYPos, isPassThru,
					MovingBlockSprite.MOVE_MODE_NORTH_SOUTH, minY, maxY, initDir, moveSpeed, name);
			
		} else if(isConveyor) {
			
//			return new ConveyorBlockSprite(isResource, theWidth, theHeight, xPosition, yPosition, passThru, thePonyPanel, theSpeed, theDirection, resourceNames, transparentColors)
			
			return new ConveyorBlockSprite(animation, width, height, initXPos, initYPos, isPassThru, moveSpeed, initDir);
			
		} else {
			//create a stationary block
			
			return new SolidBlockSprite(image, width, height, initXPos, initYPos, isPassThru);
			
		}
		
		
		
	}
	
	
	
	public static RogueBlockSpawnPoint readMovingBlockDataFromFile(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName) throws IOException {
		
		RogueBlockSpawnPoint returnValue = new RogueBlockSpawnPoint();
		
		String imageFile = null;
		returnValue.width = -1;
		returnValue.height = -1;
		returnValue.initXPos = -1;
		returnValue.initYPos = -1;
		Boolean passThruObj = null;
		returnValue.transparentColor = null;
		returnValue.minX = -1;
		returnValue.minY = -1;
		returnValue.maxX = -1;
		returnValue.maxY = -1;
		returnValue.isVertical = false;
		returnValue.isHorizontal = false;
		returnValue.moveSpeed = -1;
		returnValue.initDir = '\0';
		returnValue.name = null;
		
		
		String inputter = null;
		try {
			
			
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
					returnValue.initXPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					returnValue.initYPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
					returnValue.width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
					returnValue.height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("solid")) {
					passThruObj = false;
				} else if(inputter.contains("passThru")) {
					passThruObj = true;
				} else if(inputter.contains("graphic:")) {
					imageFile = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
					returnValue.transparentColor = CustomImageData.translateFileInStringToColor(inputter.substring(12));
				} else if(inputter.contains("minX:")) {
					returnValue.minX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxX:")) {
					returnValue.maxX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("minY:")) {
					returnValue.minY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxY:")) {
					returnValue.maxY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("speed:")) {
					returnValue.moveSpeed = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("horizontal")) {
					returnValue.isHorizontal = true;
				} else if(inputter.contains("vertical")) {
					returnValue.isVertical = true;
				} else if(inputter.contains("dir:")) {
					returnValue.initDir = inputter.charAt(4);
				} else if(inputter.contains("/movingBlock"))
					break;
				else if(inputter.contains("name:")) {
					returnValue.name = inputter.substring(5);
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file while loading movnig block data, but it didn't find one.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(returnValue.initXPos == -1 || returnValue.initYPos == -1 || imageFile == null || passThruObj == null || returnValue.width == -1 || returnValue.height == -1) {
//			System.err.println("something was null!  xPos, yPos, imageFile, passThry, width, or height");
			return null;
		}
		
		if(returnValue.isHorizontal) {
			if(returnValue.minX == -1 || returnValue.maxX == -1) {
//				System.err.println("minX or maxX was null!");
				return null;
			}
		} else if(returnValue.isVertical) {
			if(returnValue.minY == -1 || returnValue.maxY == -1) {
//				System.err.println("minY or maxY was null!");
				return null;
			}
		} else {
//			System.err.println("both isHorizontal and isVertical were null!");
			return null;
		}
		
		if(returnValue.moveSpeed == -1) {
//			System.err.println("moveSpeed was null!");
			return null;
		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.err.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
		
//		ImageIcon ii = new ImageIcon(url);
//		CustomImageData cid = new CustomImageData(ii.getImage(), returnValue.width, returnValue.height, returnValue.transparentColor, ponyPanel);
		
		if(fromFiles) {
			returnValue.image = CustomImageDataIIRepository.loadImage(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName, imageFile);
					//new CustomImageDataII(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
		} else {
			returnValue.image = CustomImageDataIIRepository.loadImage("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName);
					//new CustomImageDataII("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
		}
		
		returnValue.isPassThru = passThruObj.booleanValue();
		
		
		return returnValue;
		
		
	}
	
	
	public static RogueBlockSpawnPoint readNonMovingBlockDataFromFile(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName) throws IOException {
		
		RogueBlockSpawnPoint returnValue = new RogueBlockSpawnPoint();
		
		String imageFile = null;
		returnValue.width = -1;
		returnValue.height = -1;
		returnValue.initXPos = -1;
		returnValue.initYPos = -1;
		Boolean isPassThruObj = null;
		returnValue.transparentColor = null;
		
		String inputter = null;
			
		try {
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
					returnValue.initXPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					returnValue.initYPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
					returnValue.width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
					returnValue.height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("solid")) {
					isPassThruObj = false;
				} else if(inputter.contains("passThru")) {
					isPassThruObj = true;
				} else if(inputter.contains("graphic:")) {
					imageFile = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
					returnValue.transparentColor = CustomImageData.translateFileInStringToColor(inputter.substring(12));
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file while loading movnig block data, but it didn't find one.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(returnValue.initXPos == -1 || returnValue.initYPos == -1 || imageFile == null || isPassThruObj == null || returnValue.width == -1 || returnValue.height == -1) {
			return null;
		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.out.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
//		
//		ImageIcon ii = new ImageIcon(url);
//		returnValue.image = new CustomImageData(ii.getImage(), returnValue.width, returnValue.height, returnValue.transparentColor, ponyPanel);
		
		if(fromFiles) {
			returnValue.image = CustomImageDataIIRepository.loadImage(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName, imageFile);
					//new CustomImageDataII(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
		} else {
			returnValue.image = CustomImageDataIIRepository.loadImage("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName);
					//new CustomImageDataII("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
		}
		
		returnValue.isPassThru = isPassThruObj.booleanValue();
		
		return returnValue;
		
	}
	
	
	public static RogueBlockSpawnPoint readConveyorBlockDataFromFile(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName) throws IOException {
		
		RogueBlockSpawnPoint returnValue = new RogueBlockSpawnPoint();
		
		returnValue.width = -1;
		returnValue.height = -1;
		returnValue.initXPos = -1;
		returnValue.initYPos = -1;
		Boolean isPassThruObj = null;
		returnValue.transparentColor = null;
		
		String inputter = null;
		
		try {
			
			
			Color transColor = null;
			String tempStrArray[] = null;
			
			int frameForPopulating = 0;
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
					returnValue.initXPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					returnValue.initYPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
					returnValue.width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
					returnValue.height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("speed:")) {
					returnValue.moveSpeed = Integer.parseInt(inputter.substring(6).trim());
				}  else if(inputter.contains("dir:")) {
					returnValue.initDir = inputter.charAt(4);
				} else if(inputter.contains("solid")) {
					isPassThruObj = false;
				} else if(inputter.contains("passThru")) {
					isPassThruObj = true;
				} else if(inputter.contains("frameCount:")) {
					int totalFrames = Integer.parseInt(inputter.substring(11).trim());
					returnValue.animation = new CustomImageDataII[totalFrames];
				} else if(returnValue.animation != null) {
					tempStrArray = inputter.split("\\*");
					transColor = CustomImageData.translateFileInStringToColor(tempStrArray[1].trim());
//					ii = new ImageIcon(WidgetSprite.class.getResource(tempStrArray[0].trim()));
//					images[frameForPopulating] = new CustomImageDataII(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), transColor, ponyPanel);
					
					if(fromFiles) {
						
						if(returnValue.width != -1 && returnValue.height != -1)
							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, returnValue.width, returnValue.height, roomName, tempStrArray[0].trim());
							//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel, returnValue.width, returnValue.height);
						else
							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, roomName, tempStrArray[0].trim());
							//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel);
						
					} else {
					
						if(returnValue.width != -1 && returnValue.height != -1) {
							
//							if(returnValue.width == 200 && tempStrArray[0].trim().contains("conveyor1")) {
//								CustomImageDataIIRepository.writeToLog("There's our boy:  conveyor1 with 200 width");
								
//								Thread t = Thread.currentThread();
//								StackTraceElement e[] = t.getStackTrace();
//								
//								for(StackTraceElement an : e) {
//									
//									CustomImageDataIIRepository.writeToLog("here's hoping for answers; I'm out of it.  Stack trace: " + an.getClassName() + " : " + an.getMethodName() + ", " + an.getLineNumber());
//									
//								}
//								
//								CustomImageDataIIRepository.writeToLog("");
//							}
							
							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, returnValue.width, returnValue.height, roomName);
									//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel, returnValue.width, returnValue.height);
							
						} else {
							
							
//							if(tempStrArray[0].trim().contains("conveyor1") && roomName.contains("openingRoom")) {
//								CustomImageDataIIRepository.writeToLog("There's our boy I think:  conveyor1 with 200 width");
//								
//								Thread t = Thread.currentThread();
//								StackTraceElement e[] = t.getStackTrace();
//								
//								for(StackTraceElement an : e) {
//									
//									CustomImageDataIIRepository.writeToLog("here's hoping for answers; I'm out of iiiit.  Stack trace: " + an.getClassName() + " : " + an.getMethodName() + ", " + an.getLineNumber());
//									
//								}
//								
//								CustomImageDataIIRepository.writeToLog("");
//							}
							
							
							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, roomName);
									//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel);
						}
					}
					frameForPopulating++;
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file while loading movnig block data, but it didn't find one.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(returnValue.initXPos == -1 || returnValue.initYPos == -1 || returnValue.animation == null || returnValue.animation.length <= 0 || isPassThruObj == null || returnValue.width == -1 || returnValue.height == -1) {
			return null;
		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.out.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
//		
//		ImageIcon ii = new ImageIcon(url);
//		returnValue.image = new CustomImageData(ii.getImage(), returnValue.width, returnValue.height, returnValue.transparentColor, ponyPanel);
//		returnValue.image = new CustomImageDataII("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel);
		
		returnValue.isPassThru = isPassThruObj.booleanValue();
		
		returnValue.isHorizontal = false;
		returnValue.isVertical = false;
		returnValue.isConveyor = true;
		
		return returnValue;
		
	}
	
	
	public void primeAll(Graphics g) {
		if(image != null) {
//			image.primeImage(g, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
		}
	}
	
	
	
	

	public static void retrieveFileLengthsNonMovingBlock(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName, HashMap<String, Long> fileLengths) throws IOException {
		
//		RogueBlockSpawnPoint returnValue = new RogueBlockSpawnPoint();
//		
		String imageFile = null;
//		returnValue.width = -1;
//		returnValue.height = -1;
//		returnValue.initXPos = -1;
//		returnValue.initYPos = -1;
//		Boolean isPassThruObj = null;
//		returnValue.transparentColor = null;
		
		String inputter = null;
		
		try {
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
//					returnValue.initXPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
//					returnValue.initYPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
//					returnValue.width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
//					returnValue.height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("solid")) {
//					isPassThruObj = false;
				} else if(inputter.contains("passThru")) {
//					isPassThruObj = true;
				} else if(inputter.contains("graphic:")) {
					imageFile = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
//					returnValue.transparentColor = CustomImageData.translateFileInStringToColor(inputter.substring(12));
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file while loading movnig block data, but it didn't find one.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
//		if(returnValue.initXPos == -1 || returnValue.initYPos == -1 || imageFile == null || isPassThruObj == null || returnValue.width == -1 || returnValue.height == -1) {
//			return ;
//		}
		
		FileInputStream fis = new FileInputStream(imageFile);
		
		long lengthOfFile = 0L;
		
		while(fis.read() != -1)
			lengthOfFile++;
		
		fis.close();
		
		fileLengths.put(imageFile, lengthOfFile);
		
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.out.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
//		
//		ImageIcon ii = new ImageIcon(url);
//		returnValue.image = new CustomImageData(ii.getImage(), returnValue.width, returnValue.height, returnValue.transparentColor, ponyPanel);
		
//		if(fromFiles) {
//			returnValue.image = CustomImageDataIIRepository.loadImage(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName, imageFile);
//					//new CustomImageDataII(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
//		} else {
//			returnValue.image = CustomImageDataIIRepository.loadImage("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName);
//					//new CustomImageDataII("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
//		}
//		
//		returnValue.isPassThru = isPassThruObj.booleanValue();
		
		return ;
		
	}
	
	
	

	public static void retrieveFileLengthsMovingBlock(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName, HashMap<String, Long> fileLengths) throws IOException {
		
//		RogueBlockSpawnPoint returnValue = new RogueBlockSpawnPoint();
		
		String imageFile = null;
//		returnValue.width = -1;
//		returnValue.height = -1;
//		returnValue.initXPos = -1;
//		returnValue.initYPos = -1;
//		Boolean passThruObj = null;
//		returnValue.transparentColor = null;
//		returnValue.minX = -1;
//		returnValue.minY = -1;
//		returnValue.maxX = -1;
//		returnValue.maxY = -1;
//		returnValue.isVertical = false;
//		returnValue.isHorizontal = false;
//		returnValue.moveSpeed = -1;
//		returnValue.initDir = '\0';
//		returnValue.name = null;
		
		
		
		String inputter = null;
		
		try {
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
//					returnValue.initXPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
//					returnValue.initYPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
//					returnValue.width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
//					returnValue.height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("solid")) {
//					passThruObj = false;
				} else if(inputter.contains("passThru")) {
//					passThruObj = true;
				} else if(inputter.contains("graphic:")) {
					imageFile = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
//					returnValue.transparentColor = CustomImageData.translateFileInStringToColor(inputter.substring(12));
				} else if(inputter.contains("minX:")) {
//					returnValue.minX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxX:")) {
//					returnValue.maxX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("minY:")) {
//					returnValue.minY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxY:")) {
//					returnValue.maxY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("speed:")) {
//					returnValue.moveSpeed = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("horizontal")) {
//					returnValue.isHorizontal = true;
				} else if(inputter.contains("vertical")) {
//					returnValue.isVertical = true;
				} else if(inputter.contains("dir:")) {
//					returnValue.initDir = inputter.charAt(4);
				} else if(inputter.contains("/movingBlock"))
					break;
				else if(inputter.contains("name:")) {
//					returnValue.name = inputter.substring(5);
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file while loading movnig block data, but it didn't find one.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
//		if(returnValue.initXPos == -1 || returnValue.initYPos == -1 || imageFile == null || passThruObj == null || returnValue.width == -1 || returnValue.height == -1) {
//			System.err.println("something was null!  xPos, yPos, imageFile, passThry, width, or height");
//			return null;
//		}
//		
//		if(returnValue.isHorizontal) {
//			if(returnValue.minX == -1 || returnValue.maxX == -1) {
//				System.err.println("minX or maxX was null!");
//				return null;
//			}
//		} else if(returnValue.isVertical) {
//			if(returnValue.minY == -1 || returnValue.maxY == -1) {
//				System.err.println("minY or maxY was null!");
//				return null;
//			}
//		} else {
//			System.err.println("both isHorizontal and isVertical were null!");
//			return null;
//		}
//		
//		if(returnValue.moveSpeed == -1) {
//			System.err.println("moveSpeed was null!");
//			return null;
//		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.err.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
		
//		ImageIcon ii = new ImageIcon(url);
//		CustomImageData cid = new CustomImageData(ii.getImage(), returnValue.width, returnValue.height, returnValue.transparentColor, ponyPanel);
		
//		if(fromFiles) {
//			returnValue.image = CustomImageDataIIRepository.loadImage(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName, imageFile);
//					//new CustomImageDataII(new File(imageFile), returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
//		} else {
//			returnValue.image = CustomImageDataIIRepository.loadImage("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height, roomName);
//					//new CustomImageDataII("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel, returnValue.width, returnValue.height);
//		}
//		
//		returnValue.isPassThru = passThruObj.booleanValue();
//		
//		
//		return returnValue;
		
		FileInputStream fis = new FileInputStream(imageFile);
		
		long lengthOfFile = 0L;
		
		while(fis.read() != -1)
			lengthOfFile++;
		
		fis.close();
		
		fileLengths.put(imageFile, lengthOfFile);
		
	}
	
	

	public static void retrieveFileLengthsConveyor(BufferedReader in, PonyPanel ponyPanel, boolean fromFiles, String roomName, HashMap<String, Long> fileLengths) throws IOException {
		
		RogueBlockSpawnPoint returnValue = new RogueBlockSpawnPoint();
		
		returnValue.width = -1;
		returnValue.height = -1;
		returnValue.initXPos = -1;
		returnValue.initYPos = -1;
		Boolean isPassThruObj = null;
		returnValue.transparentColor = null;
		
		String inputter = null;
		
		try {
			
			
			Color transColor = null;
			String tempStrArray[] = null;
			
			int frameForPopulating = 0;
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
//					returnValue.initXPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					returnValue.initYPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
//					returnValue.width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
//					returnValue.height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("speed:")) {
//					returnValue.moveSpeed = Integer.parseInt(inputter.substring(6).trim());
				}  else if(inputter.contains("dir:")) {
//					returnValue.initDir = inputter.charAt(4);
				} else if(inputter.contains("solid")) {
//					isPassThruObj = false;
				} else if(inputter.contains("passThru")) {
//					isPassThruObj = true;
				} else if(inputter.contains("frameCount:")) {
					int totalFrames = Integer.parseInt(inputter.substring(11).trim());
					returnValue.animation = new CustomImageDataII[totalFrames];
				} else if(returnValue.animation != null) {
					tempStrArray = inputter.split("\\*");
					transColor = CustomImageData.translateFileInStringToColor(tempStrArray[1].trim());
//					ii = new ImageIcon(WidgetSprite.class.getResource(tempStrArray[0].trim()));
//					images[frameForPopulating] = new CustomImageDataII(ii.getImage(), ii.getIconWidth(), ii.getIconHeight(), transColor, ponyPanel);
					
//					if(fromFiles) {
//						
//						if(returnValue.width != -1 && returnValue.height != -1)
//							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, returnValue.width, returnValue.height, roomName, tempStrArray[0].trim());
//							//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel, returnValue.width, returnValue.height);
//						else
//							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(new File(tempStrArray[0].trim()), transColor, ponyPanel, roomName, tempStrArray[0].trim());
//							//new CustomImageDataII(new File(tempStrArray[0].trim()), transColor, ponyPanel);
//						
//					} else {
//					
//						if(returnValue.width != -1 && returnValue.height != -1) {
//							
//							if(returnValue.width == 200 && tempStrArray[0].trim().contains("conveyor1")) {
//								CustomImageDataIIRepository.writeToLog("There's our boy:  conveyor1 with 200 width");
//								
//								Thread t = Thread.currentThread();
//								StackTraceElement e[] = t.getStackTrace();
//								
//								for(StackTraceElement an : e) {
//									
//									CustomImageDataIIRepository.writeToLog("here's hoping for answers; I'm out of it.  Stack trace: " + an.getClassName() + " : " + an.getMethodName() + ", " + an.getLineNumber());
//									
//								}
//								
//								CustomImageDataIIRepository.writeToLog("");
//							}
//							
//							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, returnValue.width, returnValue.height, roomName);
//									//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel, returnValue.width, returnValue.height);
//							
//						} else {
//							
//							
//							if(tempStrArray[0].trim().contains("conveyor1") && roomName.contains("openingRoom")) {
//								CustomImageDataIIRepository.writeToLog("There's our boy I think:  conveyor1 with 200 width");
//								
//								Thread t = Thread.currentThread();
//								StackTraceElement e[] = t.getStackTrace();
//								
//								for(StackTraceElement an : e) {
//									
//									CustomImageDataIIRepository.writeToLog("here's hoping for answers; I'm out of iiiit.  Stack trace: " + an.getClassName() + " : " + an.getMethodName() + ", " + an.getLineNumber());
//									
//								}
//								
//								CustomImageDataIIRepository.writeToLog("");
//							}
//							
//							
//							returnValue.animation[frameForPopulating] = CustomImageDataIIRepository.loadImage(tempStrArray[0].trim(), transColor, ponyPanel, roomName);
//									//new CustomImageDataII(tempStrArray[0].trim(), transColor, ponyPanel);
//						}
//					}
					
					String fileName = tempStrArray[0];
					
					FileInputStream fis = new FileInputStream(fileName);
					
					long lengthOfFile = 0L;
					
					while(fis.read() != -1)
						lengthOfFile++;
					
					fis.close();
					
					fileLengths.put(fileName, lengthOfFile);
					
					frameForPopulating++;
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file while loading movnig block data, but it didn't find one.</html>","Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		if(returnValue.initXPos == -1 || returnValue.initYPos == -1 || returnValue.animation == null || returnValue.animation.length <= 0 || isPassThruObj == null || returnValue.width == -1 || returnValue.height == -1) {
			return ;
		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.out.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
//		
//		ImageIcon ii = new ImageIcon(url);
//		returnValue.image = new CustomImageData(ii.getImage(), returnValue.width, returnValue.height, returnValue.transparentColor, ponyPanel);
//		returnValue.image = new CustomImageDataII("/images/" + imageFile + ".GIF", returnValue.transparentColor, ponyPanel);
		
//		returnValue.isPassThru = isPassThruObj.booleanValue();
//		
//		returnValue.isHorizontal = false;
//		returnValue.isVertical = false;
//		returnValue.isConveyor = true;
		
		return ;
		
	}
	
	
}
